/*##############################################################################

				#################################################
				#												#
				#   "AWAY FROM KEYBOARD" FILTERSCRIPT BY YOM	#
				#			 STEAL MY WORK AND DIE >:D	   		#
				#                                      			#
				#################################################


- Thanks to

	- Dracoblue (dini)
	- Kyeman (animations from vactions fs)


- Copyright  Yom Productions - Do not sell or i'll kill you.


- Versions changes:

	- 0.1a :	Initial release.

	- 0.2  :    Many bugfixes,
				New animations,
				Camera rotation,
				[AFK] Name prefix,


- Known bugs:

	- None yet

- Translation from AVANGARD
################################### INDEX ######################################

DEFINES, ENUM, NEWS			Line 49
MAIN SCRIPT FUNCTIONS		Line 110
INIT, SA-MP CB, MISC		Line 278
END OF SCRIPT               Line 425

##############################################################################*/

#include <a_samp>
#include <dini>

forward AFK_Timer();

/*########################## DEFINES, ENUM, NEWS... ##########################*/


#define COL_BOX		0x000000EE
#define COL_RED		0xFF0000FF
#define COL_GREEN   0x00FF00FF
#define COL_GREY    0xAEAEAEA4

enum AFK_CONFIG
{
	bool:enable_music,
	bool:enable_rotocam,
	bool:enable_autoafk,
	bool:enable_autokick,
	autoafk_delay,
	autokick_delay
};

enum AFK_PLAYERS_INFOS
{
	bool:afk,
	bool:spawned,
	Float:pos[4],
	keys[3],
	name[24],
	object,
	time,
	idle_time
};

new	AFK_Config[AFK_CONFIG],
    AFK_PlayerInfo[MAX_PLAYERS][AFK_PLAYERS_INFOS],
    AFK_String[5][70],
    AFK_TD_String[14],
    
	AFK_Musics[]			= { 1062, 1068, 1076, 1097, 1183, 1185, 1187,
								1062, 1068, 1068, 1097, 1097, 1185, 1187 },
								
    AFK_Dances[][]			= { "DAN_Loop_A", "dnce_M_a", "dnce_M_c" },

	AFK_Version[]			=   "0.2",
	AFK_Command[]			=	"/afk",
	AFK_TimerDelay          =   100,
	Float:AFK_CamMoveRate   =   0.0,
	AFK_ConfigFile[]		=	"afk/configuration.cfg",
	
	AFK_EnableMusic[]		=   "ENABLE_MUSIC",
	AFK_EnableRotocam[]		=   "ENABLE_ROTOCAM",
	AFK_EnableAutoAfk[]		=	"ENABLE_AUTOAFK",
	AFK_EnableAutoKick[]	=	"ENABLE_AUTOKICK",
	AFK_AutoAfkDelay[]		=	"AUTOAFK_DELAY",
	AFK_AutoKickDelay[]		=	"AUTOKICK_DELAY",
	
	Text:AFK_TD_Box,
	Text:AFK_TD_Text
;

/*####################### END OF DEFINES, ENUM, NEWS... ########################



############################ MAIN SCRIPT FUNCTIONS ###########################*/

public AFK_Timer()
{
	for(new i = 0, j = GetMaxPlayers(); i < j; i++)
	{
	    if (IsPlayerConnected(i) && AFK_PlayerInfo[i][spawned])
	    {
			GetPlayerKeys(i,AFK_PlayerInfo[i][keys][0],
							AFK_PlayerInfo[i][keys][1],
							AFK_PlayerInfo[i][keys][2]);

			if (AFK_PlayerInfo[i][keys][0] + AFK_PlayerInfo[i][keys][1] +
				AFK_PlayerInfo[i][keys][2] == 0 && !AFK_PlayerInfo[i][afk])
            {
                AFK_PlayerInfo[i][idle_time] ++;

                if (AFK_PlayerInfo[i][idle_time] == AFK_Config[autoafk_delay])
					AFK_ToggleMode(i);
			}
			else
				AFK_PlayerInfo[i][idle_time] = 0;

			if (AFK_PlayerInfo[i][afk])
			{
				AFK_ChatMessages(i);
				
				if (AFK_Config[enable_rotocam])
					AFK_RotateCamera(i);
			}
		}
	}
}

AFK_RotateCamera(playerid)
{
	AFK_PlayerInfo[playerid][pos][3] += AFK_CamMoveRate;

	SetPlayerCameraPos(playerid,	AFK_PlayerInfo[playerid][pos][0] + floatcos(AFK_PlayerInfo[playerid][pos][3])*5,
									AFK_PlayerInfo[playerid][pos][1] + floatsin(AFK_PlayerInfo[playerid][pos][3])*5,
									AFK_PlayerInfo[playerid][pos][2] + 1);

	SetPlayerCameraLookAt(playerid, AFK_PlayerInfo[playerid][pos][0],
									AFK_PlayerInfo[playerid][pos][1],
									AFK_PlayerInfo[playerid][pos][2] + 0.5);
}

AFK_ToggleMode(playerid)
{
	AFK_PlayerInfo[playerid][afk] = !AFK_PlayerInfo[playerid][afk];

	GetPlayerName(playerid, AFK_PlayerInfo[playerid][name], 24);
	
	if (AFK_PlayerInfo[playerid][afk])
	{
		format(AFK_String[4],50,"* %s   !",AFK_PlayerInfo[playerid][name]);
		SendClientMessageToAll(COL_GREY, AFK_String[4]);
		strins(AFK_PlayerInfo[playerid][name],"[AFK]",0);
		SetPlayerName(playerid, AFK_PlayerInfo[playerid][name]);
		TogglePlayerControllable(playerid, false);
		GetPlayerPos(playerid,	AFK_PlayerInfo[playerid][pos][0],
								AFK_PlayerInfo[playerid][pos][1],
								AFK_PlayerInfo[playerid][pos][2]);
		GetPlayerFacingAngle(playerid, AFK_PlayerInfo[playerid][pos][3]);
	    TextDrawShowForPlayer(playerid, AFK_TD_Text);
		TextDrawShowForPlayer(playerid, AFK_TD_Box);
		AFK_PlayerInfo[playerid][time] = GetTickCount();
		AFK_ToggleEffect(playerid, true);
	}
	else
	{
		strdel(AFK_PlayerInfo[playerid][name], 0, 5);
		SetPlayerName(playerid, AFK_PlayerInfo[playerid][name]);
	    format(AFK_String[4],50,"* %s   !",AFK_PlayerInfo[playerid][name]);
		SendClientMessageToAll(COL_GREY, AFK_String[4]);
		TogglePlayerControllable(playerid, true);
	    SetCameraBehindPlayer(playerid);
		TextDrawHideForPlayer(playerid, AFK_TD_Text);
		TextDrawHideForPlayer(playerid, AFK_TD_Box);
		EmptyMessages(playerid);
		AFK_PlayerInfo[playerid][time] = 0;
		AFK_ToggleEffect(playerid, false);
	}
}

AFK_ToggleEffect(playerid, bool:toggle)
{
	if (toggle)
	{
		if (AFK_Config[enable_music])
			PlayerPlaySound(playerid,AFK_Musics[random(sizeof(AFK_Musics))], 0.0,0.0,0.0);

		if (!IsPlayerInAnyVehicle(playerid))
		{
			switch (random(6))
			{
				case 0:
				{
					ApplyAnimation(playerid,"INT_HOUSE","BED_Loop_R",4.0,1,0,0,0,0);
					AFK_PlayerInfo[playerid][object] = CreateObject(1771,
																	AFK_PlayerInfo[playerid][pos][0],
																	AFK_PlayerInfo[playerid][pos][1],
																	AFK_PlayerInfo[playerid][pos][2]-0.48,
																	0.0,
																	0.0,
																	AFK_PlayerInfo[playerid][pos][3]+75.0);
				}
				case 1: ApplyAnimation(playerid,"DANCING",AFK_Dances[random(sizeof(AFK_Dances))],4.0,1,0,0,0,0);
				case 2: ApplyAnimation(playerid,"ped","cower",3.0,1,0,0,0,0);
				case 3: ApplyAnimation(playerid,"COP_AMBIENT","Coplook_loop",4.0,0,1,1,1,-1);
				case 4: ApplyAnimation(playerid,"BEACH","bather",4.0,1,0,0,0,0);
				case 5: ApplyAnimation(playerid,"BEACH","ParkSit_M_loop",4.0,1,0,0,0,0);
			}
		}
	}

	else
	{
		ApplyAnimation(playerid, "CARRY", "crry_prtial", 4.0, 0, 0, 0, 0, 0);

		if (AFK_Config[enable_music])
			PlayerPlaySound(playerid, 1063, 0.0,0.0,0.0);

		if (IsValidObject(AFK_PlayerInfo[playerid][object]))
		{
			DestroyObject(AFK_PlayerInfo[playerid][object]);
			AFK_PlayerInfo[playerid][object] = 0;
		}
	}
}

AFK_ChatMessages(playerid)
{
	new	AFK_Time = floatround((GetTickCount() - AFK_PlayerInfo[playerid][time]) / 1000),
		AFK_Seconds = AFK_Time % 60,
		AFK_Minutes = floatround((AFK_Time/60), floatround_floor),
		AFK_KickTime = floatround(AFK_Config[autokick_delay] - AFK_Time);

	EmptyMessages(playerid);
	format(AFK_String[0], 40,"*AFK:     %02d:%02d !", AFK_Minutes, AFK_Seconds);
	SendClientMessage(playerid, COL_RED, AFK_String[0]);
	SendClientMessage(playerid, COL_RED, AFK_String[2]);
	SendClientMessage(playerid, COL_RED, "*AFK:       .");
	EmptyMessages(playerid, 3);

	if (AFK_Config[enable_autokick] && AFK_KickTime <= floatround(AFK_Config[autokick_delay]/3))
	{
		format(AFK_String[0], 50, "WARNING:       %d !", AFK_KickTime);
		SendClientMessage(playerid, COL_GREEN, AFK_String[0]);
		EmptyMessages(playerid, 2);

		if (AFK_KickTime < 1)
		{
			AFK_ToggleMode(playerid);
			SendClientMessage(playerid, COL_GREEN, AFK_String[3]);
			EmptyMessages(playerid, 1);
			Kick(playerid);
		}
	}

	else
		EmptyMessages(playerid, 3);
}

/*####################### END OF MAIN SCRIPT FUNCTIONS #########################



####################### INIT, SA-MP CALLBACKS, MISC... #######################*/

#define AFK_ini_Int(%1)		dini_Int(AFK_ConfigFile, %1)
#define AFK_ini_Bool(%1)	bool:AFK_ini_Int(%1)

AFK_Init_SetConfig()
{
	new bool:fcheck = bool:fexist(AFK_ConfigFile);
	
	AFK_Config[enable_music]	= fcheck ? (AFK_ini_Bool(AFK_EnableMusic))		: true;
	AFK_Config[enable_rotocam]	= fcheck ? (AFK_ini_Bool(AFK_EnableRotocam))	: true;
	AFK_Config[enable_autoafk]	= fcheck ? (AFK_ini_Bool(AFK_EnableAutoAfk))	: true;
	AFK_Config[enable_autokick]	= fcheck ? (AFK_ini_Bool(AFK_EnableAutoKick))	: true;
	AFK_Config[autoafk_delay]	= fcheck ? (AFK_ini_Int(AFK_AutoAfkDelay))		: 30;
	AFK_Config[autokick_delay]	= fcheck ? (AFK_ini_Int(AFK_AutoKickDelay))		: 300;

	if (AFK_Config[autokick_delay] < 60) AFK_Config[autokick_delay] = 60;
	if (AFK_Config[autoafk_delay]  < 30) AFK_Config[autoafk_delay]  = 30;
	
	AFK_Config[autoafk_delay] = floatround((AFK_Config[autoafk_delay]*1000) / AFK_TimerDelay);
}

AFK_Init_CreateTextDraws()
{
	AFK_TD_String = "_";
	AFK_TD_Box = TextDrawCreate(0.0,0.0,AFK_TD_String);
	TextDrawFont(AFK_TD_Box,1);
	TextDrawLetterSize(AFK_TD_Box, 0.0, 50.0);
	TextDrawUseBox(AFK_TD_Box, true);
	TextDrawColor(AFK_TD_Box,0);
	TextDrawBoxColor(AFK_TD_Box, COL_BOX);

    AFK_TD_String = " BbI B AFK!";
	AFK_TD_Text = TextDrawCreate(320,190,AFK_TD_String);
	TextDrawFont(AFK_TD_Text,1);
	TextDrawLetterSize(AFK_TD_Text, 1.5, 7.0);
	TextDrawAlignment(AFK_TD_Text, 2);
	TextDrawSetShadow(AFK_TD_Text, false);
	TextDrawSetProportional(AFK_TD_Text,true);
	TextDrawColor(AFK_TD_Text,COL_RED);
}

AFK_Init_CreateDefaultStrings()
{
	format(AFK_String[1],50,"     AFK FS %s",AFK_Version);
	format(AFK_String[2],70,"*AFK:     'ENTER'   %s",AFK_Command);
	format(AFK_String[3],70,"*AFK:        %d !",AFK_Config[autokick_delay]);
}

AFK_Init_CreateAnims(playerid)
{
	ApplyAnimation(playerid,"INT_HOUSE","null",0.0,0,0,0,0,0);
	ApplyAnimation(playerid,"DANCING","null",0.0,0,0,0,0,0);
	ApplyAnimation(playerid,"ped","null",0.0,0,0,0,0,0);
	ApplyAnimation(playerid,"COP_AMBIENT","null",0.0,0,0,0,0,0);
	ApplyAnimation(playerid,"BEACH","null",0.0,0,0,0,0,0);
	ApplyAnimation(playerid,"CARRY","null",0.0,0,0,0,0,0);
}

AFK_Init_ResetPlayerInfos(playerid)
{
	AFK_PlayerInfo[playerid][afk]		= false;
	AFK_PlayerInfo[playerid][spawned]	= false;
	AFK_PlayerInfo[playerid][object]	= 0;
	AFK_PlayerInfo[playerid][time]		= 0;
	AFK_PlayerInfo[playerid][idle_time]	= 0;
}

stock dbg(playerid, str[])
{
    SendClientMessage(playerid, COL_GREY, str);
    print(str);
}

EmptyMessages(playerid, count = 50)
{
    for (new i = 0; i < count; i++)
		SendClientMessage(playerid, 0, "\n");
}

public OnFilterScriptInit()
{
	AFK_Init_SetConfig();
	AFK_Init_CreateTextDraws();
	AFK_Init_CreateDefaultStrings();
	AFK_CamMoveRate = AFK_TimerDelay/4000.0;
	SetTimer("AFK_Timer", AFK_TimerDelay, true);
	printf("move : %.3f",AFK_CamMoveRate);
}

public OnPlayerConnect(playerid)
{
	AFK_Init_ResetPlayerInfos(playerid);
	AFK_Init_CreateAnims(playerid);
	SendClientMessage(playerid,COL_GREEN,AFK_String[1]);
	return true;
}

public OnPlayerSpawn(playerid)
{
	AFK_PlayerInfo[playerid][spawned] = true;
	return true;
}

public OnPlayerDeath(playerid, killerid, reason)
{
	AFK_PlayerInfo[playerid][spawned] = false;
	return true;
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if (!strcmp(cmdtext, AFK_Command))
	{
		if (AFK_PlayerInfo[playerid][spawned])
			AFK_ToggleMode(playerid);
		else
			SendClientMessage(playerid, COL_RED, "AFK:       !");

		return true;
	}

	else
		if (AFK_PlayerInfo[playerid][afk])
			return true;

	return false;
}

public OnPlayerText(playerid, text[])
{
	if (AFK_PlayerInfo[playerid][afk])
		return false;

	return true;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if (newkeys == 16 && AFK_PlayerInfo[playerid][afk])
		AFK_ToggleMode(playerid);
}

/*###################### END OF CONFIG, INIT, COMMANDS #########################



############################## END OF THE SCRIPT #############################*/
